package test

import (
	"github.com/gruntwork-io/terratest/modules/opa"
	"github.com/gruntwork-io/terratest/modules/terraform"
	"testing"
)

func TestOPA(t *testing.T) {
	t.Parallel()

	// Przetestuj kod Terraform w katalogu examples/opa.
	tfOpts := &terraform.Options{
		TerraformDir: "../examples/opa",
	}

	// Wykonaj kod Terraform z uwzględnieniem polityki OPA w pliku enforce_source.rego.
	opaOpts := &opa.EvalOptions{
		RulePath: "../../../opa/09-testing-terraform-code/enforce_source.rego",
		FailMode: opa.FailUndefined,
	}

	// Nie udało się sprawdzić czy polityka OPA działa.
	terraform.OPAEval(t, tfOpts, opaOpts, "data.enforce_source.allow")
}
